%% Example values
AHL_in = transpose(...
         [0.020 0.020 0.040 0.080 0.100 0.140 0.160 0.180 0.200 ...
          0.020 0.020 0.040 0.080 0.100 0.140 0.160 0.180 0.200]);
CI_in  = transpose(...
         [0.004 0.004 0.004 0.004 0.004 0.004 0.004 0.004 0.004 ...
          0.030 0.030 0.030 0.030 0.030 0.030 0.030 0.030 0.030]);
betagal_out = transpose(...
         [0.001 0.001 0.001 0.004 0.006 0.010 0.020 0.020 0.020 ...
          0.001 0.001 0.001 0.001 0.001 0.001 0.001 0.001 0.001]);
      
      
%% Call Fit
x_r = reshape(x_pos, size(x_pos,1)*size(x_pos,1), 1);
y_r = reshape(y_pos, size(y_pos,1)*size(y_pos,1), 1);
f_r = reshape(f,     size(f,1)    *size(f,1),     1);

[fitresult, gof] = Create_Surface_Fit(x_r, y_r, f_r);

%% Example "ideal" AHL/CI transfer function 

load 'AHL_CI_tf_ideal_1.mat'

x_r = reshape(AHL_coords,   size(AHL_coords,1)   * size(AHL_coords,  2), 1);
y_r = reshape(CI_coords,    size(CI_coords, 1)   * size(CI_coords,   2), 1);
f_r = reshape(betagal_vals, size(betagal_vals,1) * size(betagal_vals,2), 1);

surf(AHL_coords, CI_coords, betagal_vals);
colorbar;
xlabel('AHL');
ylabel('CI');
zlabel('betagal');
title('Ideal plux/cI transfer function');


%% Fit debug
%
%  For now, set n=2 always
%
flux = ['((1/2) * ((luxR_tot + (K_A_2__K_LuxR / (4 * (u1^2)))) - ' ...
        ' sqrt((luxR_tot + (K_A_2__K_LuxR / (4 * (u1^2))))^2 - (luxR_tot^2))))'];

fci  = '((u2 / 2) + (1 / (8 * K_D_CI)) * (1 - sqrt(1 + 8 * K_D_CI * u2)))';
        
fnc  = ['(c0 + c1 * ' flux ') / (1 + c0 + c1 * ' flux ' + c2 * (' fci '^n) + c1 * c2 * ' flux ' * (' fci '^n))'];  
ft = fittype(fnc, 'indep', {'u1', 'u2'}, 'depend', 'z' );

K_A_2__K_LuxR = 270000;  % nM^3
K_D_CI = 5;  % nM
c0 = 0.04;
c1 = 0.05;
c2 = 0.11;
luxR_tot = 2000; % nM
n = 1.5;  

%u1_range = 10.^(-4.0 : 0.1 : 2.00);
%u2_range = 10.^(-4.0 : 0.1 : 2.00);
u1_range = 10.^(-3.0 : 1.0 : 3.00);
u2_range = 10.^(-3.0 : 1.0 : 3.00);

x = 0;

% create matrices
x_pos      = zeros(size(u1_range,1),size(u1_range,2));
y_pos      = zeros(size(u1_range,1),size(u1_range,2));
f_computed = zeros(size(u1_range,1),size(u1_range,2));
f_fit_vals = zeros(size(u1_range,1),size(u1_range,2));

for u1 = u1_range
    x = x + 1;
    y = 0;
    
    for u2 = u2_range
        y = y + 1;
        x_pos(x,y) = u1;
        y_pos(x,y) = u2;

        f_computed(x,y) = ft(K_A_2__K_LuxR, K_D_CI, c0, c1, c2, luxR_tot, n, u1, u2);
        
    end
end

figure;
contourf(x_pos,y_pos,f_computed);

set (gca,'xscale', 'log');
set (gca,'yscale', 'log');

xlabel('AHL');
ylabel('CI');
%shading interp;
colorbar;
title('Betagal levels computed directly from function');

%
% now, try to fit curve
%
disp 'Find param values for surface fit'

opts = fitoptions( ft );
% opts.Display = 'Off';

%
% Fit Params:
% K_A_2__K_LuxR,K_D_CI,c0,c1,c2,luxR_tot,n,u1,u2
%
opts = fitoptions( ft );
% opts.Display = 'Off';
%opts.Lower = [0 0 -Inf -Inf -Inf -Inf -Inf];
%opts.Upper = [Inf Inf Inf Inf Inf Inf Inf];
%opts.StartPoint = [0.1 0.1 0.1 0.1 0.1 0.1 0.1];

opts.Lower = [0 0 -Inf -Inf -Inf 0 0];
opts.StartPoint = [0.1 0.1 0.1 0.1 0.1 0.1 0.1];
opts.Upper = [Inf Inf Inf Inf Inf Inf Inf];

%opts.Lower = [1 0.1 0.01 0.01 0.01 1 0.1];
%opts.StartPoint = [270000 5 0.04 0.05 0.11 2000 1.5];
%opts.Upper = [999999 99 9 9 9 99999 99];

opts.Weights = zeros(1,0);
opts.Robust = 'On';

x_r = reshape(x_pos,      size(x_pos,1)      * size(x_pos,     2), 1);
y_r = reshape(y_pos,      size(y_pos, 1)     * size(y_pos,     2), 1);
f_r = reshape(f_computed, size(f_computed,1) * size(f_computed,2), 1);

[fitresult, gof] = fit( [x_r, y_r], f_r, ft, opts );

for i=1:size(x_pos,1)
    for j=1:size(x_pos,2)
        f_fit_vals(i,j) = fitresult(x_pos(i,j),y_pos(i,j));
    end
end

% Plot fit with data.
figure( 'Name', 'Plux_CI surface function fit' );
%h = plot( fitresult, [x_pos, y_pos], f_fit_vals );
h = contourf(x_pos, y_pos, f_fit_vals);
g = gca;
set(g, 'XScale', 'log');
set(g, 'YScale', 'log');
% Label axes
xlabel( 'AHL' );
ylabel( 'CI' );
zlabel( 'betagal' );
colorbar;
title('Betagal values from fitted curve');
